<?php 
/**
 * Modelo para gerenciar a Home
 */
class HomeModel extends MainModel
{
	/**
	 * Construtor para essa classe
	 *
	 * Configura o DB, o controlador, os parâmetros e dados do usuário.
	 *
	 * @since 0.1
	 * @access public
	 * @param object $db Objeto da nossa conexão PDO
	 * @param object $controller Objeto do controlador
	 */
	public function __construct( $db = false, $controller = null ) {
		// Configura o DB (PDO)
		$this->db = $db;
		
		// Configura o controlador
		$this->controller = $controller;
	}
	
	/**
	 * Lista notícias
	 *
	 * @since 0.1
	 * @access public
	 * @return array Os dados da base de dados
	 */
	public function listar(){
		
		// Faz a consulta
		$query = $this->db->query(
			'select p.id, p.codigo, p.titulo, p.texto, p.slug, c.slug as categoria from procedimentos p, categorias c where p.categoria = c.id and p.status="on" and not c.slug = "ensino-integral" order by p.id desc limit 3'
		);
		
		// Retorna
		return $query->fetchAll();
	}
	
	function previa($texto, $tamanho) {
		if (strlen($texto) > $tamanho) {
			for ($i = $tamanho;$i <= strlen($texto); $i++) {
				if (substr($texto,$i,1) == " ") {
					return substr($texto,0,$i)."...";
				}
			}
			return strip_tags(stripslashes($texto));
		}

		return strip_tags(stripslashes($texto));
	}

}