<?php
/**
 * MainController - Todos os controllers deverão estender essa classe
 *
 * @WagnerLemos
 */
class MainController
{

	/**
	 * $db
	 *
	 * Nossa conexão com a base de dados. Manterá o objeto PDO
	 *
	 * @access public
	 */
	public $db;

	/**
	 * $parametros
	 *
	 * @access public
	 */
	public $parametros = array();
	
	/**
	 * Construtor da classe
	 *
	 * Configura as propriedades e métodos da classe.
	 *
	 * @access public
	 */
	public function __construct ( $parametros = array() ) {
	
		// Instancia do DB
		$this->db = new db();
		
		// Parâmetros
		$this->parametros = $parametros;
		
	}
	
	public function canonical(){
		if(array_key_exists('HTTPS', $_SERVER) && $_SERVER['HTTPS']=='on'){$protocolo = 'https';}else{$protocolo = 'http';}

		$dominio = $protocolo.'://'.$_SERVER['HTTP_HOST'];
		return $dominio."".$_SERVER['REQUEST_URI'];
	}
	
	public function get($get) {
		return isset($_GET[$get]) ? $_GET[$get] : null;
	}

	public function post($post) {
		return isset($_GET[$post]) ? $_GET[$post] : null;
	}
	
	/**
	 * Load model
	 *
	 * Carrega os modelos presentes na pasta /models/.
	 *
	 * @access public
	 */
	public function load_model( $model_name = false ) {
	
		// Um arquivo deverá ser enviado
		if ( ! $model_name ) return;
		
		// Garante que o nome do modelo tenha letras minúsculas
		$model_name =  strtolower( $model_name );
		
		// Inclui o arquivo
		$model_path = ABSPATH . '/models/' . $model_name . '.php';
		
		// Verifica se o arquivo existe
		if ( file_exists( $model_path ) ) {
		
			// Inclui o arquivo
			require_once $model_path;
			
			// Remove os caminhos do arquivo (se tiver algum)
			$model_name = explode('/', $model_name);
			
			// Pega só o nome final do caminho
			$model_name = end( $model_name );
			
			// Remove caracteres inválidos do nome do arquivo
			$model_name = preg_replace( '/[^a-zA-Z0-9]/is', '', $model_name );
			
			// Verifica se a classe existe
			if ( class_exists( $model_name ) ) {
			
				// Retorna um objeto da classe
				return new $model_name( $this->db, $this );
			
			}
			
			// The end :)
			return;
			
		} // load_model
		
	} // load_model
	
	public function render($view, $data = [])
    {
        $filename = 'views/' . $view . '.php';

        if (!file_exists($filename)) {
            throw new Exception("A view não pode ser renderizada. Arquivo <u>{$filename}</u> não encontrado.");
        }
		
		extract($data);
        ob_start();

        require_once $filename;
		echo ob_get_clean();
    }

} // class MainController